%%% ====================================================
%%% @LaTeX-file{
%%%    filename  = "BEJOMABNT.cls",
%%%    date      = 01/03/2025
%%%    author    = Tânia Carvalho
%%%    abstract  = "TEMPLATE BEJOM ABNT",
%%% }
%%% ====================================================
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{BEJOMABNT}


\LoadClass[12pt, a4paper, twoside]{article}

\setlength{\textwidth}{16cm}
\setlength{\textheight}{22cm}
\setlength{\topmargin}{0cm}
\setlength{\oddsidemargin}{0cm}
\setlength{\evensidemargin}{0cm}

%=============================================================================

\AtBeginDocument{%
    \setlength{\headheight}{33pt} % Altura do cabeçalho
    \renewcommand{\headrulewidth}{.5pt} % Espessura da linha sob cabeçalho
    \renewcommand{\footrulewidth}{.5pt} % Espessura da linha sobre o rodapé
}

\usepackage{afterpage} % Permite alterar o estilo após a primeira página


\usepackage{lineno} % Para numeração das linhas
\usepackage{dsfont}
\usepackage{subfig}
\usepackage{graphicx}
\usepackage{epsfig}
\usepackage{multirow}
\usepackage{multicol}
\usepackage{vwcol}  
\usepackage[svgnames]{xcolor}
\usepackage[breaklinks=true]{hyperref}
%\usepackage[hyphenbreaks]{breakurl}
%\usepackage{url}
%\sloppy

\usepackage{longtable}
\usepackage{caption}
\usepackage{lastpage}

\usepackage{amsfonts,amssymb,amsmath}
\usepackage{amsthm}
\usepackage{setspace}
\usepackage{fancyhdr}
\usepackage{enumerate}
\usepackage{xparse} 

%\usepackage{dsfont}
\usepackage{times}
\usepackage{titlesec}
\usepackage{array}    % Para usar a formatação das tabelas
%\usepackage{microtype}

\usepackage{placeins} % Adicione isso no preâmbulo para ativar \FloatBarrier
%=============================================================================
\newtheoremstyle{meu_estilo}  
{5pt}   % Espaço antes do ambiente
{5pt}   % Espaço depois do ambiente
{\itshape}  % Corpo do ambiente
{}   % Recuo do título
{\bfseries} % Fonte do título
{.}   % Pontuação após o título
{ }   % Espaço após o título
{}    % Cabeçalho do ambiente (opcional)
%==========================================================================

\newcommand{\B}{{\tt\symbol{92}}}
\newcommand{\chap}{{\tt\symbol{94}}}
\newcommand{\agud}{{\tt\symbol{13}}}
\newcommand{\crav}{{\tt\symbol{18}}}

\newcommand{\see}{\Leftrightarrow}
\newcommand{\N}{\mathds{N}}
\newcommand{\Z}{\mathds{Z}}
\newcommand{\Q}{\mathds{Q}}
\newcommand{\R}{\mathds{R}}
\newcommand{\C}{\mathds{C}}

%===========================================================================

% Teoremas em Inglês
\newtheorem{theorem}{Theorem} % Inglês
\newtheorem{lemma}{Lemma} % Inglês
\newtheorem{proposition}{Proposition} % Inglês
\newtheorem{definition}{Definition} % Inglês
\newtheorem{coroll}{Corollary} % Inglês
\newtheorem{statment}{Statement} % Inglês
\newtheorem{remark}{Remark} % Inglês
\newtheorem{example}{Example} % Inglês

% Teoremas em Português
\newtheorem{teorema}{Teorema} % Português
\newtheorem{lema}{Lema} % Português
\newtheorem{prop}{Proposição} % Português
\newtheorem{defin}{Defini\c{c}\~{a}o} % Português
\newtheorem{cor}{Corol\'ario} % Português
\newtheorem{afirm}{Afirma\c{c}\~{a}o} % Português
\newtheorem{obs}{Observa\c{c}\~{a}o} % Português
\newtheorem{exemplo}{Exemplo} % Português

% Teoremas em Espanhol
\newtheorem{teoremaesp}{Teorema} % Espanhol
\newtheorem{lemaesp}{Lema} % Espanhol
\newtheorem{propesp}{Proposición} % Espanhol
\newtheorem{definesp}{Definición} % Espanhol
\newtheorem{corolesp}{Corolario} % Espanhol
\newtheorem{afirmesp}{Afirmación} % Espanhol
\newtheorem{obsesp}{Observación} % Espanhol
\newtheorem{ejemplo}{Ejemplo} % Espanhol

%==========================================================================
\titlespacing*{\section}{0pt}{0.7pt}{0.6em}  % 0pt de espaço antes
\titleformat{\section}[block]
  {\normalfont\large\bfseries} % Estilo do título
  {\thesection}{1em} {} % Parte da numeração
\titlespacing*{\section}{0pt}{\baselineskip}{0.6em} % Ajustando o espaçamento entre o título e o texto

\titleformat{\subsection}[block]
  {\normalfont\normalsize\bfseries} % Estilo do título
  {\thesubsection}{1em} {} % Parte da numeração
\titlespacing*{\subsection}{0pt}{\baselineskip}{0.6em} % Ajustando o espaçamento entre o título e o texto

\titleformat{\subsubsection}[block]
  {\normalfont\normalsize\bfseries} % Estilo do título
  {\thesubsubsection}{1em} {} % Parte da numeração
\titlespacing*{\subsubsection}{0pt}{\baselineskip}{0.6em} % Ajustando o espaçamento entre o título e o texto

%=============================================================================


%==========================================================================
% Faz a mudança automática após a primeira página 
%\afterpage{\renewcommand{\headrulewidth}{0.4pt}}
%

\newcommand{\setshorttitle}[1]{\def\shorttitle{#1}}
\newcommand{\setshortauthors}[1]{\def\shortauthors{#1}}

%==========================================================================
%Definindo o ambiente de citação recuada e o comando para demonstrações
% O ambiente proof está definido par qualquer escolha do babel. Porém uma opção seria:

\newenvironment{dem}{\noindent \bfseries \textit{Demonstra\c{c}\~{a}o}. }{\hfill \qed}

% Para espanhol
\newenvironment{demesp}{\noindent \bfseries \textit{Demostración}. }{\hfill \qed}
%==========================================================================

%definindo o ambiente de citação com recuo
\def\citar{\list{}{\leftmargin4cm\singlespacing\footnotesize}\item[]}
\let\endcitar=\endlist

\renewenvironment{proof}{{\noindent  \textit{Demonstração}.} \setlength{\topsep}{1.5pt} \setlength{\parsep}{1.5pt} \setlength{\itemsep}{1.5pt} }{\hfill \qed}

%=============================================================================
\usepackage{csquotes} %%ecomendado para lidar corretamente com citações no biblatex
%Bloco para configurar as Referências nas normas ABNT
\usepackage{etoolbox} % Pacote para controlar comandos de forma mais avançada

\usepackage[backend=biber,style=abnt,sorting=nyt,language=brazilian,giveninits=true,uniquename=mininit]{biblatex}


\addbibresource{bibliografia.bib}

%\renewcommand{\mkbibparens}[1]{\MakeLowercase{#1}}

\renewcommand*{\nameyeardelim}{\addcomma\space} % Garante a vírgula como em (Lee, 2020)

% 

%\setlength{\bibitemsep}{1.0ex} % Aumentar o espaçamento entre os itens das referências. Ajuste o valor conforme necessário

%===========================================================================
%Insere a seção Licença no final do texto, antes das referências
\newcommand{\fixedsection}{%
 % \clearpage
  \section*{Licença}
  As obras submetidas ao jornal BEJOM estão sujeitas à licença { \color{blue} \href{https://creativecommons.org/licenses/by/4.0/}{CC BY 4.0}}. Sob esta licença, os autores concedem aos leitores o direito de compartilhar, adaptar e utilizar as obras, inclusive para fins comerciais, desde que o crédito apropriado seja dado aos autores. Quaisquer modificações devem ser indicadas. Não há restrições adicionais além das estabelecidas pela licença.
}

\newcommand{\printbibliographywithsection}{%
  \fixedsection
  \printbibliography
}
%=============================================================================
%Bloco de ajuste do Quadro para diferir da Tabela
\ifcsname c@quadro\endcsname
  % O contador já existe, não faz nada
\else
  \newcounter{quadro} % Define o contador para o quadro
  \renewcommand{\thequadro}{\arabic{quadro}} % Formato de numeração simples
\fi

\newenvironment{quadro}[1]{
    \FloatBarrier % Evita que o quadro "suba" ou "desça" muito
    \refstepcounter{quadro} % Incrementa o contador de quadros
    \captionsetup{type=table, labelformat=quadro} % Configuração do quadro
    \begin{table}[ht] % Mantém a tentativa de fixação
    \centering
    \captionsetup{justification=raggedright}
    \caption{#1} % Define a legenda do quadro
}{
    \end{table}
    \FloatBarrier % Evita que elementos seguintes "empurrem" o quadro
}


% Ajuste para formatar a legenda como "Quadro X:"
\DeclareCaptionLabelFormat{quadro}{Quadro \thequadro}
\captionsetup[quadro]{
    labelfont=bf,
    labelsep=colon,
    justification=raggedright,
    position=above,
    labelformat=quadro
}
%=============================================================================
\captionsetup{labelfont=bf,labelsep=space,justification=raggedright,singlelinecheck=false}% Alinha as legendas das figuras pelas normas ABNT

%=============================================================================
%Bloco de configuração das legendas das figuras
\captionsetup{
    labelfont=bf,
    labelsep=colon, % Usa "Figura X: ..." conforme a ABNT
    justification=justified,
    singlelinecheck=false,
    position=above % Legenda acima da figura
}

%=============================================================================

\linespread{1.15} %1.3 para Espaçamento entre linhas de 1.5

%\renewenvironment{proof}{{\noindent \bfseries \textit{Demonstra\c{c}\~{a}o}.}}

\def\citar{\list{}{\leftmargin4cm\singlespacing\footnotesize}\item[]}
\let\endcitar=\endlist
%=============================================================================

%% Ajuste da distância entre cabeçalho e texto
\setlength{\headsep}{1.2cm} % Controla a distância entre o cabeçalho e o texto
\setlength{\footskip}{1.0cm}
%%Altura do cabeçalho

%=============================================================================

%=============================================================================
%configuração de títulos, abstracts e palavras -chaves
\makeatletter
% ========= Comando \maketitle =========
\renewcommand{\maketitle}{%
  \null
  \vskip 0em%
  \begin{center}%
    \let \footnote \thanks
    {\bfseries \MakeUppercase{\@title}}\par
    \ifx\subtitle\undefined \else
      \vskip 0.5cm {\large \subtitle} \par
    \fi
  \end{center}%
  {\footnotesize \lineskip 0.5em
    \begin{minipage}[b]{\textwidth}
      \@author
    \end{minipage}\par
  }
  \vskip 0em%
}

% ========= Ambientes para títulos 2 e 3 com espaçamento padronizado =========
\newenvironment{titulo2}[2][]{
  \begin{center}
    \textbf{\MakeUppercase{#1}} \\[0.5cm] % espaço título->subtítulo
    \ifx&#2&\else{\large #2} \\[0.5cm]\fi % espaço subtítulo->conteúdo
  \end{center}\par
}{}

\newenvironment{titulo3}[2][]{
  \begin{center}
    \textbf{\MakeUppercase{#1}} \\[0.5cm] % espaço título->subtítulo
    \ifx&#2&\else{\large #2} \\[0.5cm]\fi % espaço subtítulo->conteúdo
  \end{center}\par
}{}

% ========= Ambiente abstract sem recuo =========
\renewenvironment{abstract}{
  \small
  \noindent\ignorespaces
}{
  \par\smallskip
}

% ========= Ambiente keywords sem recuo e espaçamento reduzido =========
\newenvironment{keywordsrecuadas}{
  \small
  \noindent\ignorespaces
}{
  \par\smallskip
}

% ========= Ambiente para encapsular abstract + keywords =========
\newenvironment{abstractkeywords}{
  \begin{abstract}
}{
  \end{abstract}
  \vspace{1.0em} % espaçamento reduzido após keywords
}

% ========= Comando para palavras-chave =========
\newcommand{\keywords}[1]{%
  \vspace{1em} % espaço simples antes das palavras-chave
  \begin{keywordsrecuadas}
    \textbf{Palavras-chave:}~#1
  \end{keywordsrecuadas}
}
\makeatother

%=============================================================================

% Definindo o layout do cabeçalho principal
\newcommand{\insertcustomheader}
{
  {\small  \noindent
    \begin{minipage}{\textwidth}
\vspace{-1.5cm}
    \begin{tabular}{@{}p{5.6cm}p{9.8cm}@{}}           
      \begin{minipage}[t]{\linewidth}
      \begin{flushleft}
               \hspace{-0.5cm} \href{https://seer.ufu.br/index.php/BEJOM/index}{ \includegraphics[height=1.65cm]{LOGOBEJOM-transp.png}} \vspace{0.6cm}\newline
                \makebox[1.4cm][r]{\href{https://creativecommons.org/licenses/by/4.0/}{\includegraphics[height=0.5cm]{CC-BY.png}}}
       \end{flushleft}
      \end{minipage}
       & 
      \vspace{-0.92cm}
      \begin{minipage}[t]{\linewidth}
        {\hfill \footnotesize Brazilian Electronic Journal of Mathematics. 2025, v.6: exxxxx}\newline \newline
        {\footnotesize  \color{blue} \hfill \url{https://doi.org/10.14393/BEJOM-v6-2025-xxxxx}}\newline \newline
        \vspace{-1cm} % ISSN sobe 1 cm
        \begin{flushright}
            {\footnotesize ISSN: 26751313 (online edition)}
        \end{flushright}
       \end{minipage}
       \newline
    \end{tabular}
    \vspace{-1cm} % Linha sobe 1 cm
  \begin{minipage}[t]{\linewidth}
        \hrulefill
  \end{minipage}
     \end{minipage}}
  }

%=============================================================================

% Configurações do cabeçalho (a linha será inserida nas páginas pares e ímpares. Comando especial para a pág 1.)
\pagestyle{fancy}
\fancyhf{} % Limpa todos os campos
\fancyhead[CO]{\footnotesize \shorttitle} % Título resumido no cabeçalho das páginas ímpares
\fancyhead[CE]{\footnotesize \shortauthors} % Autores abreviados no cabeçalho das páginas pares
\lhead{\includegraphics[height=1.0cm]{LOGO BEJOM v2.png}} % Logo à esquerda
\rhead{\thepage} % Número da página
\cfoot{} % Remove numeração do rodapé
\lfoot{\footnotesize{Braz. Elect. J. Math., Ituiutaba, v.6, n. especial, 2025, p. \thepage\ / \pageref{lastpage}.}} % Rodapé (a ser preenchido pelos editores no arquivo.cls)

% Primeira página sem linha no cabeçalho
\fancypagestyle{firstpage}{
    \fancyhf{}
    \renewcommand{\headrulewidth}{0pt} % Sem linha no cabeçalho
    \fancyhead[C]{\insertcustomheader} % Cabeçalho personalizado para a primeira página
}
%=============================================================================

\newcommand{\autorCorrespondente}[2]{%
    \par\vspace{2em} % Espaço antes das informações
    \hrule % Linha separadora
    \vspace{1em} % Espaço abaixo da linha
    \noindent % Sem recuo
    {\small Corresponding Author:}\\ 
    {\small #1, \textit{#2}} % Nome e e-mail do autor correspondente
     \label{lastpage}
}

%=============================================================================

\AtBeginDocument{\pagestyle{fancy}} % Garante que todas as páginas, exceto a primeira, usem o estilo correto
%=============================================================================

\newcommand{\submissiondates}[3]{%
  \let\thefootnote\relax
  \footnote{Submitted: #1}%
  \footnote{Accepted: #2}%
  \footnote{Published: #3}%
  \footnote{\color{blue}\url{https://seer.ufu.br/index.php/BEJOM/index}}%
}
%=============================================================================
\setcounter{page}{1} %comando para colocar o número da primeira página do artigo.
%=============================================================================

\endinput
